/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.util;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.network.message.MessageRequestSimpleConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class ConfigHelper {
    private static final Set<Path> WATCHED_PATHS = new HashSet<Path>();

    public static List<IConfigEntry> gatherAllConfigEntries(IConfigEntry entry) {
        ObjectArrayList entries = new ObjectArrayList();
        ArrayDeque<IConfigEntry> queue = new ArrayDeque<IConfigEntry>(entry.getChildren());
        while (!queue.isEmpty()) {
            IConfigEntry e = (IConfigEntry)queue.poll();
            entries.add(e);
            if (e.isLeaf()) continue;
            queue.addAll(e.getChildren());
        }
        return entries;
    }

    public static List<IConfigValue<?>> gatherAllConfigValues(IModConfig config) {
        return ConfigHelper.gatherAllConfigValues(config.getRoot());
    }

    public static List<IConfigValue<?>> gatherAllConfigValues(IConfigEntry entry) {
        ObjectArrayList values = new ObjectArrayList();
        ConfigHelper.gatherValuesFromForgeConfig(entry, values);
        return ImmutableList.copyOf((Collection)values);
    }

    private static void gatherValuesFromForgeConfig(IConfigEntry entry, List<IConfigValue<?>> values) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            if (value != null) {
                values.add(value);
            }
            return;
        }
        for (IConfigEntry children : entry.getChildren()) {
            ConfigHelper.gatherValuesFromForgeConfig(children, values);
        }
    }

    public static boolean isWorldConfig(IModConfig config) {
        return config.getType() == ConfigType.WORLD || config.getType() == ConfigType.WORLD_SYNC;
    }

    public static boolean isServerConfig(IModConfig config) {
        return config.getType().isServer() && !ConfigHelper.isWorldConfig(config);
    }

    public static boolean isConfiguredInstalledOnServer() {
        return ClientPlayNetworking.canSend((class_2960)MessageRequestSimpleConfig.ID);
    }

    public static Set<IConfigValue<?>> getChangedValues(IConfigEntry entry) {
        HashSet changed = new HashSet();
        ArrayDeque<IConfigEntry> found = new ArrayDeque<IConfigEntry>();
        found.add(entry);
        while (!found.isEmpty()) {
            IConfigEntry toSave = (IConfigEntry)found.poll();
            if (!toSave.isLeaf()) {
                found.addAll(toSave.getChildren());
                continue;
            }
            IConfigValue<?> value = toSave.getValue();
            if (value == null || !value.isChanged()) continue;
            changed.add(value);
        }
        return changed;
    }

    private static <T> T callOnEnv(EnvType type, Supplier<Supplier<T>> callable) {
        if (FabricLoader.getInstance().getEnvironmentType() == type) {
            return callable.get().get();
        }
        throw new RuntimeException("Tried to run code on the wrong environment");
    }

    public static boolean isPlayingGame() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER || (Boolean)ConfigHelper.callOnEnv(EnvType.CLIENT, () -> () -> class_310.method_1551().field_1687 != null) != false;
    }

    public static boolean isServerOwnedByPlayer(@Nullable class_1657 player) {
        return player != null && player.method_5682() != null && !player.method_5682().method_3816() && player.method_5682().method_19466(player.method_7334());
    }

    public static boolean hasPermissionToEdit(@Nullable class_1657 player, IModConfig config) {
        return !config.getType().isServer() || player != null && (player.method_5687(4) || ConfigHelper.isServerOwnedByPlayer(player));
    }

    public static boolean isOperator(@Nullable class_1657 player) {
        return player != null && player.method_5687(4);
    }

    public static boolean isRunningLocalServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && (Boolean)ConfigHelper.callOnEnv(EnvType.CLIENT, () -> () -> class_310.method_1551().method_1496()) != false;
    }

    public static boolean isPlayingLocally() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && (Boolean)ConfigHelper.callOnEnv(EnvType.CLIENT, () -> () -> class_310.method_1551().method_1576() != null) != false;
    }

    public static boolean isPlayingRemotely() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && (Boolean)ConfigHelper.callOnEnv(EnvType.CLIENT, () -> () -> {
            class_634 listener = class_310.method_1551().method_1562();
            return listener != null && !listener.method_2872().method_10756();
        }) != false;
    }

    @Nullable
    public static class_1657 getClientPlayer() {
        return FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT ? null : (class_1657)ConfigHelper.callOnEnv(EnvType.CLIENT, () -> () -> class_310.method_1551().field_1724);
    }

    public static void createBackup(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            try {
                Path configPath = fileConfig.getNioPath();
                if (Files.exists(configPath, new LinkOption[0]) && fileConfig.getFile().length() > 0L) {
                    Path backupPath = configPath.getParent().resolve(fileConfig.getFile().getName() + ".bak");
                    Files.copy(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void closeConfig(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            Path path = fileConfig.getNioPath();
            if (WATCHED_PATHS.contains(path)) {
                FileWatcher.defaultInstance().removeWatch(path);
                WATCHED_PATHS.remove(path);
            }
            fileConfig.close();
        }
    }

    public static void loadConfig(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            try {
                fileConfig.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void saveConfig(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            fileConfig.save();
        }
    }

    public static void watchConfig(UnmodifiableConfig config, Runnable callback) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            try {
                Path path = fileConfig.getNioPath();
                WATCHED_PATHS.add(path);
                FileWatcher.defaultInstance().setWatch(path, callback);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] readBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBytes(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fc = (FileConfig)config;
            return ConfigHelper.readBytes(fc.getNioPath());
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TomlFormat.instance().createWriter().write(config, (OutputStream)stream);
        return stream.toByteArray();
    }
}

